﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Menu.Sample6
{
    public partial class FormMain : Form
    {
        public const int MF_ByPosition = 0x400;
        public const int MF_ByCommand = 0x0;

        private const int MIIM_State = 0x1;
        private const int MIIM_Id = 0x2;
        private const int MIIM_SunMenu = 0x4;
        private const int MIIM_Checkmarks = 0x8;
        private const int MIIM_Data = 0x20;
        private const int MIIM_Type = 0x100;
        private const int MIIM_String = 0x40;

        private const int MFT_String = 0x0;
        private const int MFS_Enabled = 0x0;

        [Flags]
        public enum MenuFlags : uint
        {
            MF_Checked = 0x8,
            MF_Disabled = 0x2,
            MF_Grayed = 0x1,
            MF_Separator = 0x800,
            MF_String = 0x0,
            MF_Enabled = 0x0
        }

        [DllImport("user32.dll", SetLastError = true)]
        private static extern IntPtr GetMenuItemID(IntPtr hMenu, int nPosition);

        [DllImport("user32.dll", SetLastError = true)]
        public static extern IntPtr GetSystemMenu(IntPtr hwnd, bool bRevert);

        [DllImport("user32", SetLastError = true)]
        private static extern IntPtr CreatePopupMenu();

        [DllImport("user32.dll", EntryPoint = "AppendMenuA")]
        private static extern bool AppendMenu(IntPtr hMenu, MenuFlags wFlags, int wIDNewItem, string lpNewItem);

        [DllImport("user32.dll", SetLastError = true)]
        private static extern bool GetMenuItemInfo(IntPtr hMenu, int uItem, int fByPosition, ref MenuItemInfo lpmii);

        [StructLayout(LayoutKind.Sequential)]
        public struct MenuItemInfo
        {
            public uint cbSize;
            public uint fMask;
            public uint fType;
            public uint fState;
            public uint wID;
            public IntPtr hSubMenu;
            public IntPtr hbmpChecked;
            public IntPtr hbmpUnchecked;
            public IntPtr dwItemData;
            public String dwTypeData;
            public uint cch;
            public IntPtr hbmpItem;

            // Return the size of the structure
            public static uint SizeOf
            {
                get { return (uint)Marshal.SizeOf(typeof(MenuItemInfo)); }
            }
        }

        [DllImport("user32.dll")]
        public static extern bool SetMenuItemInfo(IntPtr hMenu, int nPositin, int wFlags, [In] ref MenuItemInfo lpmii);

        public FormMain()
        {
            InitializeComponent();
        }

        private void FormMain_Load(object sender, EventArgs e)
        {
        }

        private void buttonAddSubMenu_Click(object sender, EventArgs e)
        {
            IntPtr hSubMenu = CreatePopupMenu();
            if (hSubMenu != IntPtr.Zero)
            {
                AppendMenu(hSubMenu, MenuFlags.MF_String | MenuFlags.MF_Enabled, 1000, "Item 1");
                AppendMenu(hSubMenu, MenuFlags.MF_Separator, 0, null);
                AppendMenu(hSubMenu, MenuFlags.MF_String | MenuFlags.MF_Enabled, 1001, "Item 2");
                AppendMenu(hSubMenu, MenuFlags.MF_String | MenuFlags.MF_Enabled, 1002, "Item 3");
            }

            IntPtr hSystemMenu = GetSystemMenu(this.Handle, false);
            if (hSystemMenu == IntPtr.Zero) return;

            IntPtr moveMenuItemId = GetMenuItemID(hSystemMenu, 1);
            MenuItemInfo moveMenuItemInfo = new MenuItemInfo();
            moveMenuItemInfo.cbSize = MenuItemInfo.SizeOf;
            moveMenuItemInfo.fType = MFT_String;
            moveMenuItemInfo.fMask = MIIM_String;
            if (GetMenuItemInfo(hSystemMenu, moveMenuItemId.ToInt32(), MF_ByCommand, ref moveMenuItemInfo))
            {
                moveMenuItemInfo.cbSize = MenuItemInfo.SizeOf;
                moveMenuItemInfo.fMask = MIIM_SunMenu;
                moveMenuItemInfo.fType = MFT_String;
                moveMenuItemInfo.hSubMenu = hSubMenu;
                SetMenuItemInfo(hSystemMenu, moveMenuItemId.ToInt32(), MF_ByCommand, ref moveMenuItemInfo);
            }
        }
    }
}